//@author: m4d
//@help: Old TV shader from AMD/ATi rendermonkey example library
//@tags: tv, distortion, interference
//@credits: shader (c) by AMD/ATi

// --------------------------------------------------------------------------------------------------
// PARAMETERS:
// --------------------------------------------------------------------------------------------------

//transforms
float4x4 tW: WORLD;        //the models world matrix
float4x4 tV: VIEW;         //view matrix as set via Renderer (EX9)
float4x4 tVP: VIEWPROJECTION;
float4 tVPos: CAMERAPOSITION;
float4x4 tP: PROJECTION;
float4x4 tWVP: WORLDVIEWPROJECTION;

//textures
texture Tex <string uiname="Texture";>;
sampler Samp = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (Tex);          //apply a texture to the sampler
    MipFilter = LINEAR;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

texture TexRand <string uiname="Random Volume Texture";>;
sampler SampRand = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (TexRand);          //apply a texture to the sampler
    MipFilter = NONE;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    ADDRESSU = WRAP;
    ADDRESSV = WRAP;
    ADDRESSW = WRAP;
};

texture TexNoise <string uiname="Noise Volume Texture";>;
sampler SampNoise = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (TexNoise);          //apply a texture to the sampler
    MipFilter = LINEAR;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    ADDRESSU = WRAP;
    ADDRESSV = WRAP;
    ADDRESSW = WRAP;
};
//texture transformation marked with semantic TEXTUREMATRIX to achieve symmetric transformations
float4x4 tTex: TEXTUREMATRIX <string uiname="Texture Transform";>;


float frameSharpness <string UIName = "Frame Sharpness"; float UIMin = 0.00; float UIMax = 40.00;> = float( 8.40 );
float frameShape <string UIName = "Frame Shape"; float UIMin = 0.00; float UIMax = 2.00;> = float( 0.27 );
float frameLimit <string UIName = "Frame Limit"; float UIMin = -1.00; float UIMax = 1.00;> = float( 0.34 );
float time <string UIName = "Time";>;
float sin_time <string UIName = "sin Time";>;
float distortionFreq <string UIName = "Distortion Frequency"; float UIMin = 0.00; float UIMax = 10.00;> = float( 5.70 );
float distortionRoll <string UIName = "Distortion Roll"; float UIMin = 0.00; float UIMax = 1.00;> = float( 0.40 );
float distortionScale < string UIName = "Distortion Scale"; float UIMin = 0.00; float UIMax = 25.00;> = float( 6.00 );
float interference <string UIName = "Interference"; float UIMin = 0.00; float UIMax = 1.00;> = float( 0.49 );


//the data structure: "vertexshader to pixelshader"
//used as output data with the VS function
//and as input data with the PS function
struct vs2ps {
   float4 Pos: POSITION;
   float2 pos: TEXCOORD0;
   float2 img: TEXCOORD1;
};

// --------------------------------------------------------------------------------------------------
// VERTEXSHADERS
// --------------------------------------------------------------------------------------------------

vs2ps VS(
      float4 Pos: POSITION,
      float4 img : TEXCOORD0)
{
   vs2ps Out;

   Out.Pos = mul(Pos, tWVP);
   Out.pos = sign(Pos.xy);
   Out.img = mul(img, tTex);

   return Out;
}

// --------------------------------------------------------------------------------------------------
// PIXELSHADERS:
// --------------------------------------------------------------------------------------------------

float4 PS(float2 pos: TEXCOORD0, float2 img: TEXCOORD1) : COLOR {
   // Define a frame shape
   float f = (1 - pos.x * pos.x) * (1 - pos.y * pos.y);
   float frame = saturate(frameSharpness * (pow(f, frameShape) - frameLimit));

   // Interference ... just a texture filled with rand()
   float rand = tex3D(SampRand, float3(1.5 * pos, time)).r - 0.2;

   // Some signed noise for the distortion effect
   float noisy = tex3D(SampNoise, float3(0, 0.5 * pos.y, 0.1 * time)).r - 0.5;

   // Repeat a 1 - x^2 (0 < x < 1) curve and roll it with sinus.
   float dst = frac(pos.y * distortionFreq + distortionRoll * sin_time);
   dst *= (1 - dst);
   // Make sure distortion is highest in the center of the image
   dst /= 1 + distortionScale * abs(pos.y);

   // ... and finally distort
   img.x += distortionScale * noisy * dst;
   float4 image = tex2D(Samp, img);

   // Combine frame, distorted image and interference
   return frame * (interference * rand + image);
}

// --------------------------------------------------------------------------------------------------
// TECHNIQUES:
// --------------------------------------------------------------------------------------------------

technique OldTV
{
    pass P0
    {
        //Wrap0 = U;  // useful when mesh is round like a sphere
        VertexShader = compile vs_1_1 VS();
        PixelShader  = compile ps_2_0 PS();
    }
}

technique TFixedFunction
{
    pass P0
    {
        //transforms
        WorldTransform[0]   = (tW);
        ViewTransform       = (tV);
        ProjectionTransform = (tP);

        //texturing
        Sampler[0] = (Samp);
        TextureTransform[0] = (tTex);
        TexCoordIndex[0] = 0;
        TextureTransformFlags[0] = COUNT2;
        //Wrap0 = U;  // useful when mesh is round like a sphere
        
        Lighting       = FALSE;

        //shaders
        VertexShader = NULL;
        PixelShader  = NULL;
    }
}
